<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reporte de Ofertas Vencidas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding: 20px;
            font-family: Arial, sans-serif;
            font-size: 0.85rem;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
        }
        .header h3 {
            font-size: 1.4rem;
            margin-top: 10px;
        }
        .info-table td {
            padding: 8px;
            vertical-align: middle;
        }
        .info-table {
            margin-top: 20px;
            width: 100%;
        }
        .table-container {
            margin-top: 30px;
            width: 100%;
            overflow-x: auto;
        }
        .notes-table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
            word-wrap: break-word;
            font-size: 0.75rem;
        }
        .notes-table th,
        .notes-table td {
            border: 1px solid #dee2e6;
            text-align: center;
            padding: 6px;
        }
        .notes-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f2f2f2;
        }
        .logo-img {
            max-height: 80px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ public_path('storage/' . $instituto->logo) }}" class="logo-img" alt="Logo Instituto">
    </div>

    <div class="header">
        <h1>Reporte de Ofertas Vencidas</h1>
        <p>Desde: {{ $fechaInicio }} hasta {{ $fechaFin }}</p>
    </div>

    <table class="table table-bordered table-striped info-table">
        <tbody>
            <tr>
                <td><strong>Nombre del Instituto</strong></td>
                <td>{{ $instituto->nombre }}</td>
                <td><strong>DRE</strong></td>
                <td>{{ $instituto->dre }}</td>
            </tr>
            <tr>
                <td><strong>Código Modular</strong></td>
                <td>{{ $instituto->codigo_modular }}</td>
                <td><strong>Departamento</strong></td>
                <td>{{ $instituto->departamento }}</td>
            </tr>
            <tr>
                <td><strong>Provincia</strong></td>
                <td>{{ $instituto->provincia }}</td>
                <td><strong>Distrito</strong></td>
                <td>{{ $instituto->distrito }}</td>
            </tr>
        </tbody>
    </table>

    <div class="table-container">
        <table class="table table-bordered table-striped notes-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Título</th>
                    <th>Empresa</th>
                    <th>Fecha Publicación</th>
                    <th>Fecha Límite</th>
                    <th>Tipo Contrato</th>
                    <th>Remuneración</th>
                    <th>Vacantes</th>
                    <th>Lugar</th>
                </tr>
            </thead>
            <tbody>
                @foreach($ofertasVencidas as $i => $oferta)
                    <tr>
                        <td>{{ $i + 1 }}</td>
                        <td>{{ $oferta->titulo }}</td>
                        <td>{{ $oferta->empresa->nombre_empresa ?? '—' }}</td>
                        <td>{{ $oferta->fecha_publicacion }}</td>
                        <td>{{ $oferta->fecha_limite }}</td>
                        <td>{{ $oferta->tipoContrato->nombre_tipo_contrato ?? '—' }}</td>
                        <td>S/. {{ number_format($oferta->remuneracion, 2) }}</td>
                        <td>{{ $oferta->vacantes }}</td>
                        <td>{{ $oferta->lugar }}</td>
                    </tr>
                @endforeach
                @if($ofertasVencidas->isEmpty())
                    <tr>
                        <td colspan="9">No se encontraron ofertas vencidas en el rango seleccionado.</td>
                    </tr>
                @endif
            </tbody>
        </table>
    </div>
</body>
</html>
