<div class="mb-3">
    <h5 class="fw-bold text-primary">
        <i class="bi bi-journal-check me-2"></i> <?php echo e($curso->nombre); ?>

    </h5>
    <p class="mb-1"><strong>Nota Final:</strong>
        <?php if($notaFinal && is_numeric($notaFinal->promedio)): ?>
            <span class="<?php echo e($notaFinal->promedio >= 11 ? 'text-success' : 'text-danger'); ?>">
                <?php echo e(number_format($notaFinal->promedio, 2)); ?>

            </span>
        <?php else: ?>
            <span class="text-muted">-</span>
        <?php endif; ?>
    </p>
</div>

<?php if($logros->isEmpty()): ?>
    <div class="alert alert-warning">
        No hay logros registrados para este curso.
    </div>
<?php else: ?>
    <?php $__currentLoopData = $logros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $notaLogro = $logro->notasLogro()
                ->where('estudiante_id', $estudianteId)
                ->where('curso_id', $curso->id)
                ->first();
        ?>

        <div class="card mb-3 border shadow-sm rounded-4">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <span class="fw-semibold">
                    <i class="bi bi-star-fill text-warning me-2"></i><?php echo e($logro->nombre); ?>

                </span>
                <span class="badge bg-secondary">
                    Nota Logro:
                    <?php if($notaLogro): ?>
                        <?php echo e(number_format($notaLogro->nota, 2)); ?>

                    <?php else: ?>
                        -
                    <?php endif; ?>
                </span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm mb-0 table-hover table-striped">
                        <thead class="table-light">
                            <tr>
                                <th>Subcomponente</th>
                                <th>Peso (%)</th>
                                <th>Nota</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $logro->subcomponentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $notaSub = $sub->notas()
                                        ->where('estudiante_id', $estudianteId)
                                        ->first();
                                ?>
                                <tr>
                                    <td><?php echo e($sub->nombre); ?></td>
                                    <td><?php echo e($sub->peso); ?>%</td>
                                    <td>
                                        <?php if($notaSub): ?>
                                            <span class="<?php echo e($notaSub->nota >= 11 ? 'text-success' : 'text-danger'); ?>">
                                                <?php echo e(number_format($notaSub->nota, 2)); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center text-muted">No hay subcomponentes registrados.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/estudiantes/partials/notas_modal.blade.php ENDPATH**/ ?>