<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Matriculas <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Agregar Matricula <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0 text-white"><i class="fas fa-edit"></i> Registrar Matrícula</h5>
            </div>
            <div class="card-body">
                <form id="formMatricula" method="POST">
                    <?php echo csrf_field(); ?>

                    <!-- 📆 PERIODO ACADÉMICO -->
                    <div class="card mb-4 shadow-sm border-0">
                        <div class="card-header bg-light fw-bold">
                            <i class="fas fa-calendar-alt me-2"></i>Periodo Académico
                        </div>
                        <div class="card-body">
                            <label for="periodo_id" class="form-label">Seleccione periodo</label>
                            <select class="form-select" id="periodo_id" name="periodo_id" required>
                                <option value="">-- Elegir periodo académico --</option>
                                <?php $__currentLoopData = $periodos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $periodo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($periodo->id); ?>"><?php echo e($periodo->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <!-- 🧩 TIPO DE MATRÍCULA -->
                    <div class="card mb-4 shadow-sm border-0">
                        <div class="card-header bg-light fw-bold">
                            <i class="fas fa-clipboard-check me-2"></i>Tipo de Matrícula
                        </div>
                        <div class="card-body">
                            <label for="tipo_matricula" class="form-label">Seleccione tipo</label>
                            <select class="form-select" id="tipo_matricula" name="tipo_matricula" required>
                                <option value="">-- Elegir --</option>
                                <option value="nueva">Matrícula Nueva</option>
                                <option value="ordinaria">Matrícula Ordinaria</option>
                            </select>
                        </div>
                    </div>

                    <!-- 👩‍🎓 MATRÍCULA NUEVA -->
                    <div class="card mb-4 shadow-sm border-0" id="postulantesVacantes" style="display: none;">
                        <div class="card-header bg-light fw-bold">
                            <i class="fas fa-users me-2"></i>Postulantes con Vacante
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover align-middle table-sm">
                                    <thead class="table-light">
                                        <tr>
                                            <th><input type="checkbox" id="checkAll"></th>
                                            <th>ID postulante</th>
                                            <th>Postulante</th>
                                            <th>DNI</th>
                                            <th>Nota</th>
                                            <th>Plan Estudio</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $postulantesConVacante; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $postulante): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><input type="checkbox" name="postulantes[]" value="<?php echo e($postulante->postulante->id_postulante); ?>">
                                                </td>
                                                <td><?php echo e($postulante->postulante->id_postulante); ?></td>
                                                <td><strong class="text-primary"><?php echo e($postulante->postulante->nombres); ?> <?php echo e($postulante->postulante->apellidos); ?></strong></td>
                                                <td><?php echo e($postulante->postulante->dni); ?></td>
                                                <td><?php echo e($postulante->nota); ?></td>
                                                <td><span class="badge bg-primary"><?php echo e(optional($postulante->planEstudio)->nombre ?? '-'); ?></span></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- 🧾 MATRÍCULA ORDINARIA -->
                    <div id="matriculaOrdinaria" style="display: none;">
                        <div class="card mb-4 shadow-sm border-0">
                            <div class="card-header bg-light fw-bold">
                                <i class="fas fa-user-search me-2"></i>Buscar Postulante por DNI
                            </div>
                            <div class="card-body row g-3 align-items-end">
                                <div class="col-md-4">
                                    <label for="dniBuscar" class="form-label">DNI del Postulante</label>
                                    <input type="text" id="dniBuscar" name="dniBuscar" class="form-control" placeholder="Ingrese DNI">
                                </div>
                                <div class="col-md-2">
                                    <button type="button" class="btn btn-primary w-100" id="buscarPostulante">
                                        <i class="fas fa-search me-1"></i> Buscar
                                    </button>
                                </div>
                            </div>

                            <div class="card-body">
                                <div id="infoPostulante" style="display: none;">
                                    <input type="hidden" id="postulante_id" name="postulante_id"> <!-- Para enviar el ID -->

                                    <div class="mb-3">
                                        <label class="form-label">Nombre del Postulante</label>
                                        <input type="text" id="nombrePostulante" class="form-control" disabled>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">DNI</label>
                                        <input type="text" id="dniPostulante" class="form-control" disabled>
                                    </div>

                                    <div class="mb-3">
                                        <label for="plan_estudio_id" class="form-label">Plan de Estudio</label>
                                        <select class="form-select" name="plan_estudio_id" id="plan_estudio_id">
                                            <option value="">-- Seleccionar plan de estudio --</option>
                                            <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->nombre); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="semestre_id_ordinaria" class="form-label">Semestre</label>
                                        <select class="form-select" name="semestre_id_ordinaria" id="semestre_id_ordinaria">
                                            <option value="">-- Seleccionar semestre --</option>
                                            <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($semestre->id); ?>"><?php echo e($semestre->nombre); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div id="cursosPorSemestre" class="mt-3">
                                        <!-- Aquí se cargarán los cursos dinámicamente -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <!-- 🚀 BOTÓN DE ENVÍO -->
                    <div class="text-end mt-4">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-check-circle me-2"></i>Confirmar Matrícula
                        </button>
                    </div>
                </form>


            </div>
        </div>

        <!--end card-->
    </div>
    <!--end col-->
</div>


<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const tipoMatriculaSelect = document.getElementById('tipo_matricula');
        const contenedorPostulantes = document.getElementById('postulantesVacantes');
        const contenedorMatriculaOrdinaria = document.getElementById('matriculaOrdinaria');
        
        // Mostrar u ocultar el formulario según el tipo de matrícula
        tipoMatriculaSelect.addEventListener('change', function () {
            if (this.value === 'nueva') {
                contenedorPostulantes.style.display = 'block';
                contenedorMatriculaOrdinaria.style.display = 'none';
            } else if (this.value === 'ordinaria') {
                contenedorPostulantes.style.display = 'none';
                contenedorMatriculaOrdinaria.style.display = 'block';
            } else {
                contenedorPostulantes.style.display = 'none';
                contenedorMatriculaOrdinaria.style.display = 'none';
            }
        });

        // Matrícula Nueva con AJAX
        const form = document.getElementById('formMatricula');
        form.addEventListener('submit', function (e) {
            e.preventDefault(); // Prevenir el comportamiento por defecto del formulario

            const tipoMatrícula = document.getElementById('tipo_matricula').value;
            if (tipoMatrícula === 'nueva') {
                // Obtener los datos del formulario
                const postulantes = [...document.querySelectorAll('input[name="postulantes[]"]:checked')].map(chk => {
                    const postulanteRow = chk.closest('tr'); // Obtener la fila del postulante
                    const postulanteId = chk.value; // Obtener el id del postulante (valor del checkbox)
                    
                    // Buscar el span con la clase 'badge' dentro de la misma fila (tr) para obtener el nombre del plan de estudio
                    const planEstudioNombre = postulanteRow.querySelector('td:nth-child(6) .badge') ? 
                                                postulanteRow.querySelector('td:nth-child(6) .badge').textContent.trim() : '';

                    // Obtener el DNI (suponiendo que está en la cuarta columna)
                    const dni = postulanteRow.querySelector('td:nth-child(4)').textContent.trim(); // Cambiar el índice si el DNI está en otra columna

                    return { postulante_id: postulanteId, planEstudioNombre: planEstudioNombre, dni: dni }; // Devolver un objeto con los datos
                });

                if (postulantes.length === 0) {
                    alert('Por favor, seleccione al menos un postulante.');
                    return;
                }

                const periodoId = document.getElementById('periodo_id').value;

                // Obtener el token CSRF
                const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

                const formData = new FormData();
                formData.append('tipo_matricula', tipoMatrícula);
                formData.append('periodo_id', periodoId);
                formData.append('postulantes', JSON.stringify(postulantes));

                // Hacer la petición AJAX
                fetch("<?php echo e(route('matriculas.nuevaMatricula')); ?>", {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': csrfToken, // Agregar el token CSRF en el encabezado
                    },
                    body: formData,
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Mostrar alerta de éxito con SweetAlert
                        Swal.fire({
                            title: 'Matrícula completada',
                            text: 'Los postulantes han sido matriculados exitosamente.',
                            icon: 'success',
                            confirmButtonText: 'Aceptar'
                        });
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: 'Hubo un problema al registrar la matrícula.',
                            icon: 'error',
                            confirmButtonText: 'Aceptar'
                        });
                    }
                })
                .catch(error => {
                    Swal.fire({
                        title: 'Error',
                        text: 'Hubo un error en la solicitud.',
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                });
            }
        });
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const buscarBtn = document.getElementById('buscarPostulante');
        const dniInput = document.getElementById('dniBuscar');

        buscarBtn.addEventListener('click', function () {
            const dni = dniInput.value.trim();

            if (dni === '') {
                Swal.fire({
                    icon: 'warning',
                    title: 'Campo vacío',
                    text: 'Por favor, ingrese un DNI.',
                });
                return;
            }

            fetch(`<?php echo e(route('postulante.buscarPorDni')); ?>?dni=${dni}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('postulante_id').value = data.postulante.id;
                        document.getElementById('nombrePostulante').value = data.postulante.nombre;
                        document.getElementById('dniPostulante').value = data.postulante.dni;
                        document.getElementById('infoPostulante').style.display = 'block';
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'No encontrado',
                            text: data.message
                        });
                        document.getElementById('infoPostulante').style.display = 'none';
                    }
                })
                .catch(error => {
                    console.error(error);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Ocurrió un error al buscar el postulante.'
                    });
                });
        });
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
    const planSelect = document.getElementById('plan_estudio_id');
    const semestreSelect = document.getElementById('semestre_id_ordinaria');
    const cursosDiv = document.getElementById('cursosPorSemestre');
    const form = document.getElementById('formMatricula');
    const dniBuscarInput = document.getElementById('dniBuscar');

    function cargarCursos() {
        const planId = planSelect.value;
        const semestreId = semestreSelect.value;

        if (planId && semestreId) {
            fetch(`/cursos/por-plan-y-semestre?plan_estudio_id=${planId}&semestre_id=${semestreId}`)
                .then(response => response.json())
                .then(cursos => {
                    if (cursos.length === 0) {
                        cursosDiv.innerHTML = '<div class="alert alert-warning">No hay cursos disponibles para este plan y semestre.</div>';
                        return;
                    }

                    let html = `
                        <div class="mb-2 fw-bold">Seleccionar cursos a matricular:</div>
                        <table class="table table-bordered table-sm align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th><input type="checkbox" id="checkAllCursos"></th>
                                    <th>Nombre</th>
                                    <th>Tipo</th>
                                    <th>Créditos</th>
                                    <th>Horas Semestrales</th>
                                    <th>Docente</th>
                                    <th>Horario</th>
                                </tr>
                            </thead>
                            <tbody>
                    `;

                    cursos.forEach(curso => {
                        const docentes = curso.docentes_info.join(', ') || '-';
                        const horarios = curso.horarios_info.join(', ') || '-';

                        html += `
                            <tr>
                                <td><input type="checkbox" class="curso-checkbox" name="cursos[]" value="${curso.id}"></td>
                                <td>${curso.nombre}</td>
                                <td>${curso.tipo ?? '-'}</td>
                                <td>${curso.creditos ?? '-'}</td>
                                <td>${curso.horas_semestrales ?? '-'}</td>
                                <td>${docentes}</td>
                                <td>${horarios}</td>
                            </tr>
                        `;
                    });

                    html += `
                            </tbody>
                        </table>
                    `;
                    cursosDiv.innerHTML = html;
                });
        } else {
            cursosDiv.innerHTML = '';
        }
    }

    planSelect.addEventListener('change', cargarCursos);
    semestreSelect.addEventListener('change', cargarCursos);

    document.addEventListener('change', function (e) {
        if (e.target.id === 'checkAllCursos') {
            const checkboxes = document.querySelectorAll('.curso-checkbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = e.target.checked;
            });
        }
    });

    // Enviar la matrícula ordinaria con AJAX
    // Enviar la matrícula ordinaria con AJAX
    form.addEventListener('submit', function (e) {
        e.preventDefault();

        const dniBuscar = dniBuscarInput.value;
        const tipoMatrícula = document.getElementById('tipo_matricula').value;

        if (tipoMatrícula === 'ordinaria') {
            const postulanteId = document.getElementById('postulante_id').value;
            const periodoSelect = document.getElementById('periodo_id');
            const periodoId = document.getElementById('periodo_id').value;
            const periodoNombre = periodoSelect.options[periodoSelect.selectedIndex].text;
            const planEstudioId = planSelect.value;
            const semestreId = semestreSelect.value;

            const cursosSeleccionados = [...document.querySelectorAll('input[name="cursos[]"]:checked')].map(chk => chk.value);

            if (cursosSeleccionados.length === 0) {
                alert('Por favor, seleccione al menos un curso.');
                return;
            }

            const codigoMatricula = `${dniBuscar}-${periodoNombre}`;
            const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
            const formData = new FormData();

            formData.append('tipo_matricula', tipoMatrícula);
            formData.append('postulante_id', postulanteId);
            formData.append('codigo_matricula', codigoMatricula);
            formData.append('periodo_id', periodoId);
            formData.append('plan_estudio_id', planEstudioId);
            formData.append('semestre_id', semestreId);

            // Enviar cada curso como cursos[]
            cursosSeleccionados.forEach(curso => {
                formData.append('cursos[]', curso);
            });

            fetch("<?php echo e(route('matriculas.ordinariaMatricula')); ?>", {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                },
                body: formData,
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        title: 'Matrícula completada',
                        text: 'La matrícula ordinaria se completó exitosamente.',
                        icon: 'success',
                        confirmButtonText: 'Aceptar'
                    }).then(() => {
                        location.reload(); // Recargar la página después de cerrar el SweetAlert
                    });
                } else {
                    Swal.fire({
                        title: 'Error',
                        text: 'Hubo un problema al registrar la matrícula ordinaria.',
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    title: 'Error',
                    text: 'Hubo un error en la solicitud.',
                    icon: 'error',
                    confirmButtonText: 'Aceptar'
                });
            });
        }
    });

});

</script>










<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpdv.dedu.pe/resources/views/matriculas/create.blade.php ENDPATH**/ ?>