<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Reporte de Ranking</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding: 20px;
            font-family: Arial, sans-serif;
            font-size: 0.85rem;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header h3 {
            font-size: 1.4rem;
            margin-top: 10px;
        }

        .info-table td {
            padding: 8px;
            vertical-align: middle;
        }

        .info-table {
            margin-top: 20px;
            width: 100%;
        }

        .table-container {
            margin-top: 30px;
            width: 100%;
            overflow-x: auto;
        }

        .notes-table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
            word-wrap: break-word;
            font-size: 0.75rem;
        }

        .notes-table th,
        .notes-table td {
            border: 1px solid #dee2e6;
            text-align: center;
            padding: 6px;
        }

        .notes-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }

        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f2f2f2;
        }

        .promedio {
            font-weight: bold;
            color: #007bff;
        }

        .logo-img {
            max-height: 80px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img class="logo-img" src="data:image/jpeg;base64,<?php echo e($imagenBase64); ?>" alt="Logo del Instituto">
        <h3><?php echo e($instituto['nombre']); ?></h3>
    </div>

    <div class="header">
        <h1>Reporte de Ranking de Estudiantes</h1>
        <h2>Unidad Didáctica: <?php echo e($curso_info['curso']); ?></h2>
    </div>

    <table class="table table-bordered table-striped info-table">
        <tbody>
            <tr>
                <td><strong>Nombre del IEST/IES/EEST</strong></td>
                <td><?php echo e($instituto['nombre']); ?></td>
                <td><strong>DRE</strong></td>
                <td><?php echo e($instituto['dre']); ?></td>
            </tr>
            <tr>
                <td><strong>Código Modular</strong></td>
                <td><?php echo e($instituto['codigo_modular']); ?></td>
                <td><strong>Tipo de Gestión</strong></td>
                <td>Pública</td>
            </tr>
            <tr>
                <td><strong>Departamento</strong></td>
                <td><?php echo e($instituto['departamento']); ?></td>
                <td><strong>Provincia</strong></td>
                <td><?php echo e($instituto['provincia']); ?></td>
            </tr>
            <tr>
                <td><strong>Distrito</strong></td>
                <td><?php echo e($instituto['distrito']); ?></td>
                <td><strong>Modalidad</strong></td>
                <td>Presencial</td>
            </tr>
            <tr>
                <td><strong>Programa de Estudio</strong></td>
                <td><?php echo e($curso_info['carrera']); ?></td>
                <td><strong>Periodo Lectivo</strong></td>
                <td><?php echo e($curso_info['periodo']); ?></td>
            </tr>
            <tr>
                <td><strong>Variante de la denominación del Programa de Estudio</strong></td>
                <td><?php echo e($curso_info['carrera']); ?></td>
                <td><strong>Periodo de Clases</strong></td>
                <td><?php echo e($curso_info['periodo']); ?></td>
            </tr>
            <tr>
                <td><strong>Nivel Formativo</strong></td>
                <td>Profesional Técnico</td>
                <td><strong>Periodo Académico</strong></td>
                <td><?php echo e($curso_info['semestre']); ?></td>
            </tr>
            <tr>
                <td><strong>Tipo Plan de Estudios</strong></td>
                <td>Transversal</td>
                <td><strong>Docente</strong></td>
                <td><?php echo e($curso_info['docente']); ?></td>
            </tr>
        </tbody>
    </table>

    <div class="table-container">
        <table class="table table-bordered table-striped notes-table">
            <thead>
                <tr>
                    <th>Puesto</th>
                    <th>Estudiante</th>
                    <th>DNI</th>
                    <?php $__currentLoopData = $logros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th><?php echo e($logro); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th>Promedio</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $estudiantes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estudiante): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($estudiante['nombre']); ?></td>
                        <td><?php echo e($estudiante['dni']); ?></td>
                        <?php $__currentLoopData = $logros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td><?php echo e($estudiante['logros'][$logro] ?? 'N/A'); ?></td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <td class="promedio"><?php echo e(number_format($estudiante['promedio'], 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/reportes/reporte-ranking.blade.php ENDPATH**/ ?>